﻿#ifndef _TPM_20_INFO
#define _TPM_20_INFO
#include "TpmTIS.h"
//#include "Tpm20.h"
//#include "ShellLib.h"
//#include "Tpm20_Types.h"
//#include "Tpm20Implementation.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"

/********************Function pointer to status check function******************/
typedef void (*TPM_STATUS_CHECK_PROC) ();
typedef UINT8 TPM_AUTHDATA[20];
typedef TPM_AUTHDATA TPM_ENCAUTH;
CHAR16 *ptr;

#pragma pack (push,1)

//default password: Intel TXT
//PH_Password is SHA256(Intel TXT)
#define PH_Password 44c7283727dbf5661dbcc4a858291596daba32c14237840446f23c17d2617ed5

#define MAX_FILE_LENGTH 32
/***************************TPM Locality 0 Base*****************************************/
#define TPM_BASE_0	0x0FED40000

typedef  UINT32             TPM_CC;
#define  TPM_CC_PolicyNvWritten               (TPM_CC)(0x0000018F)

/*****************2.1	Architectural Design Limits***********************************/

#define	T2T_MAX_DIGEST		64		//maximum digest size
#define	T2T_MAX_PCR			24		//maximum number of PCRs in a bank
#define	T2T_MAX_SOS			4		//maximum SizeOfSelect (minimum is MAX_PCR/8)
#define	T2T_MAX_PCR_ALG 	4		//maximum number of PCR algorithms
#define	T2T_MAX_BANKS		2		//maximum number of PCR BANKS supported
#define	T2T_MAX_KEY			256		//maximum key size
#define	T2T_MAX_DATABUF		1024	//max size for a data buffer (1024 min)
#define	T2T_MAX_CC			256		//maximum number of commands
#define	T2T_MAX_SESSIONS	5		//maximum number of sessions in a command

/***************2.2	Variable Data Reference (VDR) Structures**************************/

//bufType  -- indicates if the buffer holds data or a filename where the data can be read
typedef 	UINT8			VDR_BUF_TYPE;
#define	NULL_BUFFER			0x00	// buffer contains no information
#define	DATA_BUFFER			0x01	// buffer contains the data
#define ASCIIFILENAME		0x02	// buffer contains ASCII filename
#define U16FILENAME			0x03	// buffer contains 16-bit Unicode filename
#define	PROMPT_FILE			0xFE	// Prompt user for Filename 
#define	PROMPT_DATA			0xFF	// Prompt user for data (password)

//fileType
typedef 	UINT8			VDR_FILE_TYPE;
#define	FILE_EXT			0x00	//use file extension to determine type
#define	T2T_FILE			0x01	//File is a T2T_DATA file
#define	RAW_DATA			0x02	//File contains raw data
#define	ASCII_FILE			0x03	//File contains hexadecimal characters in ASCII
#define	U8_FILE				0x04	// File contains hexadecimal characters in 8-bit Unicode 
#define	U16_FILE			0x05	// File contains hexadecimal characters in 16-bit Unicode 
#define	LCP_FILE			0x06	//Policy definition file from WinLCP tool
//non-file values (bufType=NULL_BUF)
#define	CONFIG_DIGEST		0xF0	//retrieve data from Config.digest[dataIndex]
#define	CONFIG_KEY			0xF1	//retrieve data from Config.key[dataIndex]
#define CONFIG_AUTH			0xF2	//retrieve data from Config.auth[dataIndex]
#define CONFIG_DATA         0xF3    //new fileType to retrieve/store data in Configdata[dataIndex]

#define RP_BUF_MAX 			2048
#define MAX_CMD_SIZE 		2048

//command constants
#define FULL_SELFTEST		1
#define PARTIAL_SELFTEST	0

//Error codes for NvVerifyDef
#define ERROR_INVALID_INDEX		0xFF
#define ERROR_NAME_ALG			0x10
#define ERROR_ATTRIBUTES        0x08
#define ERROR_AUTH_POLICY       0x04
#define ERROR_DATA_SIZE         0x02
#define ERROR_AUTH_VALUE        0x01

// Table 195 - TPMA_NV Bit Masks

#define TPMA_PPWRITE         0x1
#define TPMA_OWNERWRITE      0x2
#define TPMA_AUTHWRITE       0x4
#define TPMA_POLICYWRITE     0x8
#define TPMA_COUNTER         0x10
#define TPMA_BITS            0x20
#define TPMA_EXTEND          0x40
#define reserved7__9         0x380
#define TPMA_POLICY_DELETE   0x400
#define TPMA_WRITELOCKED     0x800
#define TPMA_WRITEALL        0x1000
#define TPMA_WRITEDEFINE     0x2000
#define TPMA_WRITE_STCLEAR   0x4000
#define TPMA_GLOBALLOCK      0x8000
#define TPMA_PPREAD          0x10000
#define TPMA_OWNERREAD       0x20000
#define TPMA_AUTHREAD        0x40000
#define TPMA_POLICYREAD      0x80000
#define reserved20__24       0x1F00000
#define TPMA_NO_DA           0x2000000
#define TPMA_ORDERLY         0x4000000
#define TPMA_CLEAR_STCLEAR   0x8000000
#define TPMA_READLOCKED      0x10000000
#define TPMA_WRITTEN         0x20000000
#define TPMA_PLATFORMCREATE  0x40000000
#define TPMA_READ_STCLEAR    0x80000000



//2.2.1	VDR_DIGEST Structure Definition 
typedef struct {	//Variable Data Reference for Digests, etc.
	VDR_BUF_TYPE	bufType;
	VDR_FILE_TYPE	fileType;
	UINT16			dataIndex;
	UINT32			reserved;
	UINT16			maxSize	; //T2T_MAX_DIGEST
	UINT16			size;
	BYTE			buffer[T2T_MAX_DIGEST];
} VDR_DIGEST;

//2.2.2	VDR_KEY Structure Definition 
//For when a larger amount of data is needed such as for a 2048 bit RSA Key
typedef struct {	//Variable Data Reference for Digests, etc.
	VDR_BUF_TYPE	bufType;
	VDR_FILE_TYPE	fileType;
	UINT16			dataIndex;
	UINT32			reserved;
	UINT16			maxSize	; //T2T_MAX_KEY
	UINT16			size;
	BYTE			buffer[T2T_MAX_KEY];
} VDR_KEY;

//2.2.3	VDR_DATABUF Structure Definition 
//For the maximum amount of data to send to the TPM.
typedef struct {	//Variable Data Reference for Digests, etc.
	VDR_BUF_TYPE	bufType;
	VDR_FILE_TYPE	fileType;
	UINT16			dataIndex;
	UINT32			reserved;
	UINT16			maxSize;//	T2T_MAX_DATABUF;
	UINT16			size;
	BYTE			buffer[T2T_MAX_DATABUF];
} VDR_DATABUF;


//2.3.1	FSEU_HA (digest)
typedef struct {	//Fixed size for TPMU_HA.
	BYTE			digest[T2T_MAX_DIGEST];
} FSEU_HA;
	
//2.3.2	FSxT_HA (alg, digest)
typedef struct {	//Fixed size for TPMT_HA.
	UINT16			hashAlg;
	BYTE			buffer[T2T_MAX_DIGEST];
} FSET_HA;

typedef struct {	//Fixed size reference buffer for TPMT_HA.
	UINT16			hashAlg;
	VDR_DIGEST		buffer;
} FSRT_HA;

//2.3.3	FSx2B_DATA  (size, alg, digest)
typedef struct {	//Fixed size buffer for TPM2B_DATA.
	UINT16			size;
	FSET_HA			buffer;	 //includes AlgID
} FSE2B_DATA;

typedef struct {	//Fixed size reference buffer for TPM2B_DATA.
	UINT16			size;
	FSRT_HA			buffer;	 //includes AlgID
} FSR2B_DATA;

//2.3.4	FSx2B_AUTH  (size, VDR_digest)
typedef struct {	//Fixed size buffer for Digests, Nonces, AuthValues, etc.
	UINT16			size;	//any size up to associated hash algorithm digest size
	BYTE			buffer[T2T_MAX_DIGEST];
} FSE2B_AUTH;

typedef struct {	//Fixed size reference buffer for Digests, Nonces, AuthValues, etc.
	UINT16			size;	//any size up to associated hash algorithm digest size
	VDR_DIGEST		buffer;
} FSR2B_AUTH;

//2.3.5	FSx2B_NONCE  (size, VDR_digest)
typedef	FSE2B_AUTH	FSE2B_NONCE; //Nonce size restrictions
typedef	FSR2B_AUTH	FSR2B_NONCE; //Nonce size restrictions

//2.3.6	FSx2B_DIGEST  (size, VDR_digest)
typedef	FSE2B_AUTH	FSE2B_DIGEST;  // Must be expected size
typedef	FSR2B_AUTH	FSR2B_DIGEST;  // Must be expected size

//2.3.7	FSx2B_OPERAND  (size, VDR_digest)
typedef	FSE2B_AUTH	FSE2B_OPERAND; //may be any size up to Digest size
typedef	FSR2B_AUTH	FSR2B_OPERAND; //may be any size up to Digest size

//2.3.8	FSx2B_NAME  (size, VDR_digest)
typedef	FSE2B_AUTH	FSE2B_NAME;	// Must be digest size
typedef	FSR2B_AUTH	FSR2B_NAME;	// Must be digest size

//2.3.9	FSR2B_DATABUF  (size, VDR_databuf)
typedef struct {	//Fixed size buffer for data
	UINT16			size;
	VDR_DATABUF		buffer;
} FSR2B_DATABUF;

//2.3.10	FSR2B_EVENT  (size, VDR_databuf)
typedef	FSR2B_DATABUF	FSR2B_EVENT;

//2.3.11	FSR2B_MAX_BUFFER  (size, VDR_databuf)
typedef	FSR2B_DATABUF	FSR2B_MAX_BUFFER;

//2.3.12	FSR2B_MAX_NV_BUFFER  (size, VDR_databuf)
typedef	FSR2B_DATABUF	FSR2B_MAX_NV_BUFFER;

//2.3.13	FSE2B_TIMEOUT  (size, buf_8)
typedef struct {	//Fixed size buffer for TPM2B_TIMEOUT.
	UINT16			size;
	BYTE			buffer[8];
} FSE2B_TIMEOUT;

//2.3.14	FSE2B_IV  (size, buf_16)
typedef struct {	//Fixed size buffer for TPM2B_IV.
	UINT16			size;
	BYTE			buffer[16];
} FSE2B_IV;

//2.3.15	FSES_PCR_SELECT  (sizeOfSelect, buf_4)
typedef struct {	//for TPMS_PCR_SELECT
	UINT8		sizeOfSelect;			// size of the pcrSelect array
	BYTE			pcrSelect[T2T_MAX_SOS];	// the bit map of selected PCR
} FSES_PCR_SELECT ;

//2.3.16	FSES_PCR_SELECTION  (alg,  sizeOfSelect, buf_4)

typedef struct {	//for TPMS_PCR_SELECTION
	TPMI_ALG_HASH	hashAlg;				// hash algorithm associated with the selection
	UINT8			sizeOfSelect;			// size of the pcrSelect array
	BYTE			pcrSelect[T2T_MAX_SOS]; // the bit map of selected PCR
} FSES_PCR_SELECTION;	

//2.3.17	FSRT_TK  (tag, hierarchy,  size, VDR_digest)
typedef struct {	//for Ticket
	TPM_ST			tag;			//structure tag indicating the type of the ticket
	TPMI_RH_HIERARCHY hierarchy;	//the hierarchy of the proof value
	FSR2B_DIGEST	digest;			//the HMAC over the ticket-specific data
} FSRT_TK ;

//2.3.18	FSEL_CC  (count, buf_CC)
typedef struct {	//Fixed size buffer TPML_CC.
	UINT32			count;
	TPM_CC			commandCodes[T2T_MAX_CC];
} FSEL_CC;

//2.3.19	FSRL_DIGEST  (count, 8-size/VDR_digest)
typedef struct {	//Fixed size buffer TPML_DIGEST.
	UINT32	count;
	FSR2B_DIGEST	digests[8];
} FSRL_DIGEST;

//2.3.20	FSRL_DIGEST_VALUES  (count, 24-alg/VDR_digest)
typedef struct {	//Fixed size buffer TPML_DIGEST_VALUES.
	UINT32			count;
	FSRT_HA			digests[T2T_MAX_PCR_ALG];
} FSRL_DIGEST_VALUES;

//2.3.21	FSE2B_DIGEST_VALUES  (size, buffer)
typedef struct {	//Fixed size buffer TPM2B_DIGEST_VALUES.
	UINT16			size;	
	BYTE			buffer[T2T_MAX_PCR_ALG * T2T_MAX_DIGEST];
} FSE2B_DIGEST_VALUES;

//2.3.22	FSEL_PCR_SELECTION  (count, #-SoS/pcrSelect)
typedef struct {	//Fixed size buffer for TPML_PCR_SELECTION.
	UINT32			count;
	FSES_PCR_SELECTION	pcrSelections[T2T_MAX_PCR_ALG];
} FSEL_PCR_SELECTION;

//2.3.23	FSRS_AUTH_COMMAND  (…VDR, VDR)
//AUTH SESSION AREA in a command requiring authorization (not used??)
typedef struct {	//Fixed size buffer for TPMS_AUTH_COMMAND.
	TPM_HANDLE		sessionHandle;
	FSR2B_NONCE 	nonce;
	TPMA_SESSION 	sessionAttributes;
	FSR2B_AUTH		hmac;
} FSRS_AUTH_COMMAND;

//2.3.24	FSE_KEY  (size, buffer)
typedef struct {	//Fixed size buffer for KEY.
	UINT16	Size;
	UINT8	buffer[T2T_MAX_KEY];
} FSE_KEY;

//2.3.25	FSR2B_KEY  (size, VDR_Key)
typedef struct {	//Fixed size buffer for KEY.
	UINT16	size;
	VDR_KEY	buffer;
} FSR2B_KEY;

//2.3.26	FSRU_PUBLIC_KEY (size, VDR_key)
typedef 	FSR2B_KEY	FSR2B_PUBLIC_KEY ;	

//2.3.27	FSRS_SIGNATURE (HashAlg, size, VDR_key)
typedef struct {	//Fixed size buffer for TPMS_SIGNATURE_xxx.
	TPMI_ALG_HASH		hashAlg; //UINT16
	FSR2B_PUBLIC_KEY	signature;
} FSRS_SIGNATURE;

//2.3.28	FSRU_SIGNATURE (HashAlg, size, VDR_key)
typedef 	FSRS_SIGNATURE	FSRU_SIGNATURE;

//2.3.29	FSRT_SIGNATURE (SignAlg, Hashalg, size, VDR_key)
typedef struct {	//Fixed size buffer for TPMT_SIGNATURE.
	TPMI_ALG_SIG_SCHEME	sigAlg;		//UINT16
	FSRU_SIGNATURE		signature;
} FSRT_SIGNATURE;

//2.3.30	FSRS_NV_PUBLIC  (… VDR)
typedef struct {	//Fixed size buffer for TPM_NV_PUBLIC.
	TPMI_RH_NV_INDEX 	nvIndex; 	//4
	TPMI_ALG_HASH		nameAlg; 	//2
	TPMA_NV				attributes; //4
	//UINT32				attributes;
	FSR2B_DIGEST		authPolicy; //34
	UINT16				dataSize; 	//2
} FSRS_NV_PUBLIC;					//46

//2.3.31	FSR2B_NV_PUBLIC  (size, … VDR)
typedef struct {	//Fixed size buffer for TPM2B_NV_PUBLIC.
	UINT16				size;		// size of nvPublic
	FSRS_NV_PUBLIC		nvPublic;	// the public area
} FSR2B_NV_PUBLIC;

typedef struct {                    //ParamBlock
   UINT8            type;       //0=only data; 1= TPM2B sized buffer
   FSR2B_DATABUF    data;       //contains command parameters
} T2T_PARAM_BLOCK;



/*********************************Section 3	- Common File Formats***************************/

// file signature
#define	TPM2TOOL_SIG	’Tpm2Tool’ //0x54 70 6D 32 54 6F 6F 6C 

// UINT8 TOOL_ID values
#define	ID_TPM2PROV			0x01
#define	ID_WIN_TPM2			0x02
#define	ID_LINUX_TPM2		0x03

// UINT8 TOOL_LEVEL values
#define	LVL_ DEVELOPMENT	0x01	// in development
#define	LVL_REL_CANDIDATE	0x02	//release candidate
#define	LVL_RELEASED		0x08	//released

// UINT8 TPM_FAMILY values
#define	TPM1_2_FAMILY		0x12
#define	TPM2_FAMILY			0x20

// UINT8 FILE_TYPE values
#define	COMMAND_FILE		0x01
#define	SESSION_DEF_FILE	0x02	
#define	NV_DEF_FILE			0x03
#define	POL_DEF_FILE		0x04
#define	CMD_DEF_FILE		0x05
#define	DATA_FILE			0x06
#define	PHASH_FILE			0x07
#define	KEY_FILE			0x08
#define	RESPONSE_FILE		0x09
#define	OBJECT_FILE			0x0A
#define	OBJECT_NAME_FILE	0x0B
#define	EXTERNAL_OBJ_FILE	0x0C
#define	CONFIG_FILE			0x40
	
// UINT8 STRUCT_FLAGS values
#define	EXPIRIMENTAL_BIT	BIT0
#define	REL_CANDIDATE_BIT	BIT1

typedef	struct {	//Architectural Limits
	UINT8	maxDigestSize;		//T2T_MAX_DIGEST;
	UINT8	maxNumPcrs;			//T2T_MAX_PCR;
	UINT8	maxSoS;				//T2T_MAX_SOS;
	UINT8	maxNumPcrAlg;		//T2T_MAX_PCR_ALG;
	UINT8	maxNumBanks;		//T2T_MAX_BANKS;
	UINT8	reserved1; 			//0;
	UINT8	reserved2; 			//0;
	UINT8	reserved3; 			//0;
	UINT16	maxKeySize;			//T2T_MAX_KEY;
	UINT16	maxDataBufSize;		//T2T_MAX_DATABUF;
	UINT16	maxNumCmdCodes;		//T2T_MAX_CC:
	UINT16	reserved4;			//0;
	UINT16	reserved5;			//0;
	UINT16	reserved6;			//0;
	UINT32	reserved7;			//0;
} T2T_ARCHLIMITS; 



typedef struct { 	//FILE HEADER
	CHAR16	fileSig[10]; 		//‘Tpm2Tool’;	
	UINT8	Tool_ID;			// Tool that last saved this file 
	UINT8	ToolVersion;		// That tool’s version 
	UINT8	toolLevel;			//0x00;	// Development/Release Candidate/Released
	UINT8	tpmFamily;			//0x20;	// TPM version (1.2 / 2.0)
	UINT8	fileType;			// Identifies following structure. 
	CHAR16	tpmType[5];			//0;	// reserved for future definition
	UINT8	StructVer;			//0;	// 
	UINT8	StructFlags;		// Experimental, Release Candidate
	T2T_ARCHLIMITS	designLimits;	//Architectural design limits
} FILE_HEADER;

/*****************************3.3	NV DEF File*************************************/

#define	NVDEF_VER		0x00	// increment any time a reserved field is defined

//verify values: Controls what gets verified. Ignored for index creation.
#define	V_READAUTH		bit0	//Able to Read using AuthValue
#define	V_NAMEALG		bit1	//Name Algorithm must match
#define	V_AUTHPOLICY	bit2	//AuthPolicy must match
#define	V_DATASIZE		bit3	//Data size must match
#define	V_ATTRIBUTES	bit4	//Attributes (per mask)must match

typedef struct {	//NV DEF File
	FILE_HEADER		fHeader;		//fileType=NV_DEF_FILE, StructFlags= EXPERIMENTAL,
	//			StructVer=NV_DEF_VER, 
	UINT32			hierarchy;		//TPM_RH_PLATFORM or TPM_RH_OWNER
	FSR2B_AUTH		auth;			// the authorization data
	FSR2B_NV_PUBLIC	publicInfo;		//the public parameters of the NV area
	UINT32			verify;			// specifies how to verify this index
	UINT32			attibuteMask;  	//indicates which attributes must match
	FSR2B_DATABUF	dataSource;		//for Write or Compare operations
	UINT16			offset;			// for Write or Compare operations
	UINT32			reserved;
	UINT32			reserved1;
	UINT32			reserved2;
} T2T_NV_DEF_FILE ;


/******************************3.4	Session DEF File********************************/

#define	SESSION_DEF_VER	0x00	// increment any time a reserved field is defined

//Session Types defined by TCG:
#define		TPM_SE_HMAC		0x00
#define		TPM_SE_POLICY	0x01
#define		TPM_SE_TRIAL	0x03
//Additional Session Type values used in DEF files:
#define		INACTIVE		0xFF	//Session invalidated
#define		TPM_SE_PW		0xF0	//Use built in PW Session handle (TPM_RS_PW=0x40000009)

//NonceType values
#define	NONCE_EMPTY		0x00	//use nonceSize=0
#define	NONCE_RANDOM	0x01	//use a random value
#define	NONCE_CONSTANT	0xA5	//use a string of 0xA5 values

//authSource values
#define	EMPTY_AUTH		0x00	//use EMPTY auth (i.e., size =0)
#define	DEF_FILE_AUTH	0x01	//use AuthValue in this DEF file
#define	PLATFORMAUTH	0x02	//use PlatformAuth value from config file
#define	OWNERAUTH		0x03	//use OwnerAuth value from config file
#define	SAVEDAUTH0		0xA0	//use saved auth value authVale[0] in config file
#define	SAVEDAUTH1		0xA1	//use saved auth value authVale[1] in config file
#define	SAVEDAUTH2		0xA2	//use saved auth value authVale[2] in config file
#define	SAVEDAUTH3		0xA3	//use saved auth value authVale[3] in config file
#define	SAVEDAUTH4		0xA4	//use saved auth value authVale[4] in config file

typedef struct {	//Session DEF File
	FILE_HEADER		fHeader;	//fileType=SESSION_DEF_FILE, StructFlags = EXPERIMENTAL
	//			StructVer=SESSION_DEF_VER
	TPM_HANDLE		tpmKey;	//initially only support Unsalted (TPM_RH_NULL)
	TPM_HANDLE		bind;	//initially only support Unbounded (TPM_RH_NULL)
	UINT16			nonceSize;	//specifies size of caller Nonce in StartAuthSession()
	UINT8			nonceType; 	//[ RANDOM | CONSTANT | EMPTY]
	FSR2B_KEY		encryptedSalt;	//to be used in Session Setup	
	TPM_SE			sessionType;	// [HMAC|POLICY|TRIAL|PW]
	TPMT_SYM_DEF	symmetric;	//to be used in Session Setup – shall be TPM_ALG_NULL for now
	TPMI_ALG_HASH	authHashAlg;	//Hash algorithm to use
	TPMA_SESSION	sessionAttr;	//Session attributes in SESSION AREA of command being authorized
	UINT8			authSource;	//indicates where to get the authValue
	FSR2B_AUTH		authValue;	// value to use for SESSION AREA HMAC (if selected by authSource)
	UINT16			saltEncMode;
	FSR2B_AUTH		salt;
	FSR2B_KEY		saltKey;
	FSR2B_AUTH		bindValue;
	UINT32			reserved;
	UINT32			reserved1;
	UINT32			reserved2;
} T2T_SESSION_DEF_FILE;

/*************3.5	Policy Assertion DEF File (T2T_POLICY_DEF_FILE)*************************/
//This is an attempt to create one file structure that can be used for all policy assertions

#define T2T_MAX_DATA 1024

typedef struct {
	UINT16			size;
	UINT8			buffer[T2T_MAX_DATA];
} T2P_DATA;

#define	POLICY_DEF_VER	0x00	// increment any time a reserved field is defined

//POLICY_DEF_VER indicates if any changes are made to T2T_POLICY_DEF_FILE structure definition. It is initially set to 0x00 and incremented when defining a reserved fields and/or any new values.

typedef struct {	//Variable Data Reference for Digests, etc.
	UINT8	source;	// 0x00 – Prov Tool; 0x01 – this file
	UINT8	provType;	// indicates which array when source=0x00
	UINT16	provIndex;	// array index when source=0x00
	UINT16	size;	// Set to 0 if source =0x00
	UINT8	buffer[T2T_MAX_DATA];	// number of bytes specified by size
} T2T_DATA;

typedef struct {
	T2T_DATA	approvedPolicy;
	T2T_DATA	policyRef;
	T2T_DATA	keySign;
	T2T_DATA	checkTicket;
} T2T_POLA_AUTHORIZE;

/*******************3.5.1	T2T_POLA_SIGNED******************************/

typedef struct {	//Policy Assertion = PolicySigned
	TPM_HANDLE		authObject;	//PolSigned, PolSecret, PolNV, 
	FSR2B_NONCE		nonceTPM;	//PolSigned, PolSecret,
	FSR2B_DIGEST	cpHashA;	// PolSigned, PolSecret,PolTicket, PolCpHash
	FSR2B_NONCE		policyRef;	// PolSigned, PolSecret,PolTicket, 
	UINT32			expiration;	// PolSigned, PolSecret,
	FSRT_SIGNATURE	auth;	// PolSigned, 
} T2T_POLA_SIGNED;

/*******************3.5.2	T2T_POLA_SECRET******************************/
typedef struct {	//Policy Assertion = PolicySecret
	TPM_HANDLE		authObjHandle;	//PolSigned, PolSecret, PolNV, 
	FSR2B_NONCE		nonceTPM;	//PolSigned, PolSecret,
	FSR2B_DIGEST	cpHashA;	// PolSigned, PolSecret,PolTicket, PolCpHash
	FSR2B_NONCE		policyRef;	// PolSigned, PolSecret,PolTicket, 
	UINT32			expiration;	// PolSigned, PolSecret,
} T2T_POLA_SECRET;

//This is a structure that is able to hold many of TPM2B_ structures received from the TPM such as digests, tickets, blobs or any other information that the tool will use as is.
typedef struct {	//Fixed size buffer for TPM2B_TIMEOUT.
	UINT16		size;
	BYTE		buffer[100];
} T2P_TPM2B_100;

/******************3.5.3	T2T_POLA_TICKET******************************/
typedef struct {	//Policy Assertion = PolicyTicket
	FSE2B_TIMEOUT	timeout;	//PolTicket, 
	FSR2B_DIGEST	cpHashA;	// PolSigned, PolSecret,PolTicket, PolCpHash
	FSR2B_NONCE		policyRef;	// PolSigned, PolSecret,PolTicket, 
	FSR2B_NAME		authName;	//PolTicket, 
	T2P_TPM2B_100 	ticket;	//PolTicket, 
	UINT32			reserved;
	UINT32			reserved1;
	UINT32			reserved2;
	UINT32			reserved3;
} T2T_POLA_TICKET;

/*******************3.5.4	T2T_POLA_OR***********************************/
typedef struct {	//Policy Assertion = PolicyOR
	UINT32  		digestCount;	//polOR
	FSR2B_DIGEST	digests[8];		//PolOR, 
	UINT32			reserved;
	UINT32			reserved1;
	UINT32			reserved2;
	UINT32			reserved3;
} T2T_POLA_OR;

/******************3.5.5	T2T_POLA_PCR******************************/
typedef struct {	//Policy Assertion = PolicyPCR
	FSR2B_DIGEST	pcrDigest;	//PolPCR
	FSES_PCR_SELECTION	pcrs;	//PolPCR
	UINT32			reserved;
	UINT32			reserved1;
	UINT32			reserved2;
	UINT32			reserved3;
} T2T_POLA_PCR ;

/********************3.5.6	T2T_POLA_LOCALITY*************************/
typedef struct {	//Policy Assertion = PolicyLocality
	TPMA_LOCALITY	locality;	//PolLocality
} T2T_POLA_LOCALITY ;
			
/*******************3.5.7	T2T_POLA_NV****************************/
typedef struct {	//Policy Assertion = PolicyNV
	TPM_HANDLE		authHandle;	// PolNV, 
	TPM_HANDLE		nvIndex;	// PolNV, 
	FSE2B_OPERAND	operandB;	//PolNV, PolCntrTime
	UINT16			offset;		//PolNV, PolCntrTime
	TPM_EO			operation;	//PolNV, PolCntrTime
} T2T_POLA_NV ;

/*******************3.5.8	T2T_POLA_CNTRTIMER***********************/
typedef struct {	//Policy Assertion = PolicyCounterTimer
	FSE2B_OPERAND	operandB;	//PolNV, PolCntrTime
	UINT16			offset;		//PolNV, PolCntrTime
	TPM_EO			operation;	//PolNV, PolCntrTime
} T2T_POLA_CNTRTIMER ;

/******************3.5.9	T2T_POLA_CC***************************/
typedef struct {	//Policy Assertion = PolicyComandCode
	TPM_CC			code;	//PolCC
} T2T_POLA_CC ;

/*******************3.5.10	T2T_POLA_CPHASH**************************/
typedef struct {	//Policy Assertion = PolicyCpHash
	FSR2B_DIGEST	cpHashA;	// PolSigned, PolSecret,PolTicket, PolCpHash
} T2T_POLA_CPHASH ;

/********************3.5.11	T2T_POLA_NAMEHASH**********************/
typedef struct {	//Policy Assertion = PolicyNameHash
	FSR2B_DIGEST	nameHash;	//PolNameHash
} T2T_POLA_NAMEHASH ;

/********************3.5.12	T2T_POLA_DUP******************************/
typedef struct {	//Policy Assertion = PolicyDuplication
	FSR2B_NAME		objectName;		//PolDup
	FSR2B_NAME		newParentName;	//PolDup
	TPMI_YES_NO		includeObject;	//PolDup
} T2T_POLA_DUP ;

typedef struct {	// ticket is produced by TPM2_VerifySignature().
	TPM_ST			tag;		//Must be TPM_ST_VERIFIED – UINT16
	TPM_HANDLE		hierarchy;	// Handle of the hierarchy containing keyName - UINT32
	FSE2B_DIGEST	digest;		// HMAC produced using a proof value of hierarchy
} FSET_TK_VERIFIED;

/********************3.5.13	T2T_POLA_AUTHORIZE**************************/
/*
typedef struct {	//Policy Assertion = PolicyAuthorize
	FSR2B_DIGEST	approvedPolicy;	// digest of the policy being approved
	FSR2B_NONCE		policyRef;	// a policy qualifier
	FSR2B_NAME		keySign;	// Name of a key that can sign a policy addition
	FSET_TK_VERIFIED	checkTicket;	//ticket validating approvedPolicy and policyRef were signed by keySign
} T2T_POLA_AUTHORIZE;
*/

typedef struct {    //Policy Assertion = PolicyNvWritten
  TPMI_YES_NO writtenSet; 
} T2T_POLA_NV_WRITTEN;

/*********************3.5.14	T2T_POLA_NULL***************************/
typedef struct {	//Policy Assertion = PolicyAuthValue  or PolicyPhysicalPresence  or PolicyPassword
	UINT32			reserved;	// 
} T2T_POLA_NULL;

typedef struct {	//Policy Definition File
	FILE_HEADER		fHeader;	//fileType=POL_DEF_FILE, StructFlags = EXPERIMENTAL
						//			StructVer=POLICY_DEF_VER
	TPM_CC			assertion;	//indicates which TPM2_PolicyXXX command to issue
	UINT32			reserved;
	UINT32			reserved1;
	UINT32			reserved2;
	//T2TU_POL_PARAMS	params;	//A structure dependent on the value of assertion. 
	union {
		T2T_POLA_SIGNED		paramsSign;	//assertion = TPM_CC_PolicySigned
		T2T_POLA_SECRET		paramsSecret;	//assertion = TPM_CC_PolicySecret
		T2T_POLA_TICKET		paramsTicket;	//;assertion = TPM_CC_PolicyTicket
		T2T_POLA_OR			paramsOR;	//;assertion = TPM_CC_PolicyOR
		T2T_POLA_PCR		paramsPCR;	//;assertion = TPM_CC_PolicyPCR
		T2T_POLA_LOCALITY	paramsLOC;	//;assertion = TPM_CC_PolicyLocality
		T2T_POLA_NV			paramsNV;	//;assertion = TPM_CC_PolicyNV 
		T2T_POLA_CNTRTIMER	paramsCT;	//;assertion = TPM_CC_PolicyCounterTimer
		T2T_POLA_CC			paramsCC;	//;assertion = TPM_CC_PolicyCommandCode
		T2T_POLA_CPHASH		paramsCp;	//;assertion = TPM_CC_PolicyCpHash
		T2T_POLA_NAMEHASH	paramsName;	//;assertion = TPM_CC_PolicyNameHash
		T2T_POLA_DUP		paramsDup;	//;assertion = TPM_CC_PolicyDuplicationSelect  -- never use
		T2T_POLA_AUTHORIZE	paramsAuth;	//;assertion = TPM_CC_PolicyAuthorize
		T2T_POLA_NV_WRITTEN paramsNvWritten; //;assertion = TPM_CC_PolicyAuthorize
		T2T_POLA_NULL		noParams;	//;assertion = TPM_CC_PolicyNvWritten  or
										//      TPM_CC_PolicyPhysicalPresence  or
										//      TPM_CC_PolicyPassword
	} T2TU_POL_PARAMS;
	
} T2T_POLICY_DEF_FILE ;

/********************3.5.15	FSET_TK_VERIFIED Structure Definition*******/
//This is a ticket produced by the TPM using TPM2_VerifySignature() padded to be a fixed sized structure.



/*******************3.6	PolSet File**********************************/
//Used in setting primary policy
typedef struct {	//File for setting Primary Policy
	FILE_HEADER		fHeader;	//fileType=POL_SET_FILE, StructFlags= EXPERIMENTAL, StructVer=0
	TPM_RH			hierarchy;
	TPM_ALG_ID		alg;
	FSR2B_DIGEST	digest;
} T2T_POL_SET_FILE;


/******************3.8	Digest List File*************************/
typedef struct {	//Digest List File
	FILE_HEADER		fHeader;	//fileType=DIGEST_FILE, StructVer=0, StructFlags= EXPERIMENTAL
	UINT16			alg;		//Hash algorithm (0 if unknown)
	UINT16  		count;		//Number of digests in the list
	FSR2B_DIGEST	digest[24];	//the session number corresponds to the digest location in the array
} T2T_DIGEST_LIST_FILE;

/*******************3.9	Key File *********************************/
typedef struct {	//Key File
	FILE_HEADER		fHeader;		//fileType=KEY_FILE, StructVer=0, StructFlags= EXPERIMENTAL
	//2B_Private	//
	UINT16			privateSize;	//
	BYTE			privateBuf[512];//66x4+2+256/2 = 394
	//2B_PUBLIC	//
	UINT16			publicSize;	//
	BYTE			publicBuf[650];	//544+ 	
} T2T_KEY_FILE;

/*****************3.10	Command File*****************************/
typedef struct {	//TPM Command File
	FILE_HEADER		fHeader;			//fileType=COMAND_FILE, StructVer=0; StructFlags = EXPERIMENTAL
	UINT16 			CmdSize;			// size of command
	UINT8 			Data[MAX_CMD_SIZE];	// command	
} T2T_CMD_FILE;

/******************3.11	Data File*********************************/
typedef struct {	//for input data
	FILE_HEADER		fHeader;			//fileType=DATA_FILE, StructVer=0, StructFlags= EXPERIMENTAL
	UINT16			DataSize;			// size of data
	UINT8			Data[T2T_MAX_DATABUF];	// data	
} T2T_DATA_FILE;

/*****************Section 5	Tpm2Prov Structures***************************************************************/
//Constants and Structures defined for the TPM2Prov tool start with “T2P_”.

/****************5.1	Architectural Design Limits****************************/
//Architectural Limits – any changes to these values after initial release will result in a major revision of the tool:

#define	T2P_MAX_DIGEST		64		//maximum digest size
#define	T2P_MAX_PCR			24		//maximum number of PCRs in a bank
#define	T2P_MAX_SOS			4		//maximum SizeOfSelect (minimum is MAX_PCR/8)
#define	T2P_MAX_PCR_ALG 	4		//maximum number of PCR algorithms
#define	T2P_MAX_BANKS		2		//maximum number of PCR BANKS supported
#define	T2P_MAX_KEY			256		//maximum key size
#define	T2P_MAX_DATABUF		1024	//max size for a data buffer (1024 min)
#define	T2P_MAX_CC			256		//maximum number of commands

/*****************5.2	Referenced Structures*****************************/
/*****************5.2.1	T2P_TPM2B_100*************************************/


/****************5.3	TPM Message Structures**************************/
/****************5.3.1	 Design Parameters******************************/

#define	MAX_CMD_HANDLES		5	//in a command – expect no more than 3
#define	AUTH_AREA_MAX		689 //4+T2T_MAX_SESSIONS*(9+2*T2T_MAX_DIGEST)
#define	CP_BUF_MAX			1200

/****************5.3.2	Command Header**********************************/
typedef struct {
	UINT16		tag;
	UINT32		commandSize;
	UINT32		commandCode;
} T2P_CMD_HEADER;

/*****************5.3.3	Handle Area*************************************/
typedef struct {
	UINT8		handeCount;
	UINT32		handle[MAX_CMD_HANDLES];
} T2P_HANDLE_AREA;

/******************5.3.4	TPM Command Area****************************/
typedef struct {
	UINT32		offset;
	UINT32		headroom;
	UINT8		buf[T2T_MAX_DATABUF];
} T2P_CMDAREA;

/******************5.3.4.1	Auth Area***********************************/
typedef struct {
	UINT32		offset;
	UINT32		headroom;
	UINT8		buf[AUTH_AREA_MAX];
} T2P_AUTHAREA;

/******************5.3.4.2	Command Parameters*************************/
 typedef struct {
	UINT32		offset;
	UINT32		headroom;
	UINT8		buf[CP_BUF_MAX];
} T2P_CP_BUF;

/*****************5.3.5	TPM Response Header****************************/
typedef struct {
	UINT16		tag;
	UINT32		responseSize;
	UINT32		responseCode;
	UINT8		buf[RP_BUF_MAX];	//handles[], paramSize, params[],authArea[] 
} T2P_RP_BUF;

/*****************5.3.6	SGL******************************************/
typedef struct {
	UINT32		size;
	UINT64		address;
} T2P_SGL_ELEMENT;

typedef struct {
	T2P_SGL_ELEMENT		header;
	T2P_SGL_ELEMENT		handles;
	T2P_SGL_ELEMENT		authArea;
	T2P_SGL_ELEMENT		paramBuf;
} T2P_CMD_SGL;

//Usage:
// T2P_CMD_SGL	gCmdSGL;	//create Scatter Gather List for Command Message
//CmdSGL.header.addrress  = &CmdHeader	//constant
//CmdSGL.handles.addrress  = &HAndleArea	//constant
//CmdSGL.authArea.addrress  = &AuthArea	//constant
//CmdSGL.paramBuf.addrress  = &CpBuf		//constant
//CmdSGL.header.size  = 10			//constant
//gpCmdSGL = &gCmdSGL


/*****************5.4	T2P_SESSION_CONTEXT Structure******************/
typedef struct {   // Session Info
	//info for Start Session Command
	TPM_HANDLE		sessionHandle; //UINT32 session start auth session
	T2P_TPM2B_100	lastNonceTpm;	//store nonce from tpm after start authsession
	// Info from sDEF file
	TPM_HANDLE		tpmKey;	//initially only support Unsalted (TPM_RH_NULL)
	TPM_HANDLE		bind;	//initially only support Unbounded (TPM_RH_NULL)
	UINT16			nonceSize;	//specifies size of caller Nonce in StartAuthSession()
	UINT8			nonceType; 	//[ RANDOM | CONSTANT | EMPTY]
	FSR2B_KEY		encryptedSalt;	//to be used in Session Setup
	TPM_SE			sessionType;	// [INACTIVE|HMAC|POLICY|TRIAL|PW]
	TPMT_SYM_DEF	symmetric;	//to be used in Session Setup – shall be TPM_ALG_NULL for now
	TPMI_ALG_HASH	authHashAlg;	//Hash algorithm to use -- UINT16
	TPMA_SESSION	sessionAttr;	//Session attributes in SESSION AREA of command being authorized
	UINT8			authSource;	//indicates where to get the authValue
	FSR2B_AUTH		authValue;	// value to use in creating SESSION AREA (if selected)
	UINT32			reserved;
	UINT32			reserved1;
	UINT32			reserved2;
} T2P_SESSION_CONTEX;


/****************5.5	T2P_AUTH**************************************/
typedef struct {
	UINT16			size;
	UINT8			buffer[T2T_MAX_DIGEST];
} T2P_AUTH;

typedef  T2P_AUTH	T2P_DIGEST;
typedef  T2P_AUTH	T2P_NONCE;




/****************5.6	T2P__SEQUENCE_CONTEXT************************/
typedef struct {
	TPM_HANDLE		seqHandle;	//UINT32
	T2P_AUTH		authValue;
	UINT32			reserved;
} T2P_SEQUENCE_CONTEXT;

/****************5.7	T2P__HASH_SEQ_CONTEXT***********************/
typedef struct {
	TPM_HANDLE		seqHandle;
	T2P_AUTH		authValue;
} T2P_HASH_SEQ_CONTEXT;

/***************5.8	Config File (Tpm2Prov.cfg)*********************/
//CONFIG_VER indicates if any changes are made to T2P_CONFIG_FILE structure definition. It is initially set to 0x00 and incremented when defining a reserved field and/or any new values.

#define	CONFIG_VER	0x00	// increment any time a reserved field is defined

typedef struct {   // config file
	FILE_HEADER				fHeader;	//fileType=CONFIG_FILE, StructFlags= EXPERIMENTAL
	//			StructVer=CONFIG_VER, 
	FSR2B_AUTH				platformAuth;	//
	FSR2B_AUTH				ownerAuth;	//
	T2P_AUTH				authValue[5];	//storage for 5 authValues
	UINT32					objHandle[10];	//storage for 10 handles
	T2P_DIGEST				digest[8];	//storage for 8 digests
	T2P_SESSION_CONTEX		session[5];	//storage for 5 sessions
	FSR2B_KEY				key[4];	//storage for 4 keys TODO - get struct from Bill
	T2P_SEQUENCE_CONTEXT	hmacSequence;	//information for HMAC sequence
	T2P_SEQUENCE_CONTEXT	hashSequence;	//information for HASH sequence
	T2P_DATA                data[8];              //storage for 8 data elements
	UINT32					reserved;
	UINT32					reserved1;
	UINT32					reserved2;
	UINT32					reserved3;
} T2P_CONFIG_FILE;


// Table 123 -- TPM2B_SYM_KEY from outputStructDef <I/O>
typedef struct {
    UINT16    keySize;
    BYTE      key[MAX_SYM_DATA];
} FSR2B_SYM_KEY;

// Table 124 -- TPMS_SENSITIVE_CREATE from outputStructDef <I>
typedef struct {
    FSR2B_AUTH   userAuth;
    FSR2B_KEY    data;
} FSRS_SENSITIVE_CREATE;

// Table 125 -- TPM2B_SENSITIVE_CREATE from outputStructDef <I,S>
typedef struct {
    UINT16                   size;
    FSRS_SENSITIVE_CREATE    sensitive;
} FSR2B_SENSITIVE_CREATE;

typedef struct {   // config file
	TPM_ST					tag;
	UINT32					responseSize;
	UINT32					responseCode;
	TPM_HANDLE				objectHandle;
	UINT32					ParameterAreaSize;
	TPM2B_PUBLIC			outPublic;	//
	TPM2B_CREATION_DATA		creationData;
	TPM2B_DIGEST			creationHash;
	TPMT_TK_CREATION		creationTicket;
	TPM2B_NAME				name;
} TPM20_CREATE_PRIMARY_OUT;

typedef struct {   // config file
	TPM_ST					tag;
	UINT32					responseSize;
	UINT32					responseCode;
	TPM_HANDLE				objectHandle;
	TPM2B_NAME				name;
} TPM20_LOAD_EXTERNAL_OUT;

typedef struct {   // config file
	TPM_ST					tag;
	UINT32					responseSize;
	UINT32					responseCode;
	UINT32					ParameterAreaSize;
	UINT8					paramData[1024];
	/*
	TPM2B_PRIVATE			outPrivate;
	
	
	TPM2B_PUBLIC			outPublic;	//
	TPM2B_CREATION_DATA		creationData;
	TPM2B_DIGEST			creationHash;
	TPMT_TK_CREATION		creationTicket;
	*/
} TPM20_CREATE_OUT;

typedef struct {   // config file
	FILE_HEADER				fHeader;	//fileType=CONFIG_FILE, StructFlags= EXPERIMENTAL
	//			StructVer=CONFIG_VER, 
	TPM_RH					hierarchy;
	FSR2B_SENSITIVE_CREATE	inSensitive;
	TPM2B_PUBLIC			inPublic;	//
	FSR2B_DATABUF			outsideInfo;
	TPML_PCR_SELECTION		creationPCR;
} T2T_K_DEF_FILE;

#define CMD_VER		0x00       // increment any time a reserved field is defined
#define DATA_ONLY	0
#define SIZED_BUFFER 1

#define   PARAM_DATA           0x00   // Not a sized buffer
#define   PARAM_TPM2B          0x01   // TPM2B sized buffer 

#define       SKIP_PARAM		0      // skip over the indicated response data
#define       REPLACE_PARAM		1      // copy the response data to config file array
#define       APPEND_PARAM		2      // append to the existing config file array data

       //     CONFIG_DIGEST 0xF0   //save data in Config.digest[]
       //     CONFIG_KEY    0xF1   //save data in Config.key[]
       //     CONFIG_AUTH   0xF2   //save data in Config.authValue[]
       //     CONFIG_DATA   0xF3   //save data in Config.data[]

typedef struct {                 //Response Parameter Block Type
UINT8     rpType;       // indicates if data in response is a TPM2B sized buffer or not
UINT8     action;       // one of *_PARAM (skip|store|append)
UINT16    rpSize;       // ignore if TPM2B sized buffer, 
// else number of bytes in response to store/skip
UINT8     arrayName;    // a CONFIG_* value to indicate which array
UINT16    arrayIndex;   // specifies index
UINT8      includeSize;   // include the size field (in BigE) in the data
} T2T_R_PARAM_BLOCK;                               



typedef struct {                    //TPM Command File
   FILE_HEADER       fHeader;    //fileType=CMD_DEF_FILE, StructFlags = EXPERIMENTAL
   //                             StructVer=CMD_VER
   UINT8            cmdType;    //reserved, set to 0
   UINT8            subType;    //reserved, set to 0
   UINT8             CpEncrypt;  //indicates if first command param is encrypted
   UINT8             RpEncrypt;  //indicates if first response param is encrypted
   UINT32           cmdCode;    //the command code (little endian)
   UINT8            numHandles; //indicates number of handles to include
   UINT32           handle[10];   //array of handles
   INT8             OutHandle;  //-1 discard, 0 none, , 1 store
   UINT8            handleIndex;  //indicates where to store
   UINT8			numCommandParams;
   T2T_PARAM_BLOCK  *Cp;       //contains command parameters
   UINT8			numResponseParams;
   T2T_R_PARAM_BLOCK  *Rp;       //specifies storage of response parameters
   UINT32           reserved;   
   UINT32           reserved1;
   UINT32           reserved2;
} T2T_CDEF_FILE;

//Note that these parameters should be treated as opaque objects (except for size). There should be no reason to marshal or un-marshal them.
typedef struct {                    //TPM Command File
   FILE_HEADER      fHeader;    //fileType=CMD_DEF_FILE, StructFlags = EXPERIMENTAL
   //                             StructVer=CMD_VER
   T2P_DATA		    encryptedPrivate ;  //
   T2P_DATA			keyPublic;  //
   T2P_DATA         creationData ;    //
   T2P_DIGEST       creationHash ; //
   T2P_DIGEST       creationTicket  ;   //
   T2P_DIGEST       name;  //
} T2T_SOBJ_FILE;


typedef  T2P_DATA	T2T_KEY;


typedef struct {                    //TPM Command File
   FILE_HEADER      fHeader;    //fileType=CMD_DEF_FILE, StructFlags = EXPERIMENTAL
   //                             StructVer=CMD_VER
   UINT16			iSymAlg;
   UINT16			iSymKeyBits;
   UINT16			iSymMode;
   T2T_KEY			iSymKey;
   T2P_DATA		    wrappedPrivate ;  //
   T2P_DATA			oEncSeed;  //
   T2P_DATA         publicKey ;    //
   T2P_DIGEST       name;  //
} T2T_DUP_FILE;

/****************************NVIndexes Attributes***************************************/
#define	PPWRITE			0x1	
#define	OWNERWRITE		0x2	
#define	AUTHWRITE		0x4	
#define	POLICYWRITE		0x8	
#define	POLICY_DELETE	0x400	
#define	WRITEDEFINE		0x2000	
#define	PPREAD			0x10000	
#define	OWNERREAD		0x20000	
#define	AUTHREAD		0x40000
#define	POLICYREAD		0x80000	
#define	NO_DA			0x2000000	
#define	PLATFORMCREATE	0x40000000	

#define AUX_ATTRIB_POC	POLICYWRITE + PPREAD + OWNERREAD + AUTHREAD + POLICYREAD + NO_DA + PLATFORMCREATE + PPWRITE
#define	AUX_ATTRIB	POLICYWRITE + PPREAD + OWNERREAD + AUTHREAD + POLICYREAD + NO_DA + PLATFORMCREATE
#define	PS_ATTRIB 	PPWRITE + AUTHWRITE + PPREAD + OWNERREAD + AUTHREAD + POLICYREAD + NO_DA + PLATFORMCREATE
#define	PO_ATTRIB 	OWNERWRITE + AUTHWRITE + PPREAD + OWNERREAD + AUTHREAD + POLICYREAD

/*****************************************************************************************/

#define BYTETOBINARYPATTERN "%d%d%d%d%d%d%d%d"
#define BYTETOBINARY(byte)  \
  (byte & 0x80 ? 1 : 0), \
  (byte & 0x40 ? 1 : 0), \
  (byte & 0x20 ? 1 : 0), \
  (byte & 0x10 ? 1 : 0), \
  (byte & 0x08 ? 1 : 0), \
  (byte & 0x04 ? 1 : 0), \
  (byte & 0x02 ? 1 : 0), \
  (byte & 0x01 ? 1 : 0) 

typedef struct {
	UINT16 tag;					// 2
	UINT32 responseSize;		// 4
	UINT32 responseCode;		// 4
	UINT32 authSessionHandle;	// 4
	UINT16 nonceSize;			// 2
	UINT8  tpmNonce[100];		// 20
} TPM_2_0_StartAuthSession_Out;
/*
typedef struct {
	UINT16 tag;					// 2
	UINT32 commandSize;			// 4
	UINT32 commandCode;			// 4
	UINT32 policySession;		// 4
	UINT8  locality;			// 1
} TPM_2_0_PolicyLocality_In;
*/

typedef struct {
	UINT16 tag;					// 2
	UINT32 commandSize;			// 4
	UINT32 commandCode;			// 4
	UINT32 policySession;		// 4
} TPM_2_0_CMD_HEADER_POL;

typedef struct {
	UINT16 tag;
	UINT32 responseSize;
	UINT32 responseCode;
	UINT16 digestSize;
	UINT8  digestData[64];
} TPM_2_0_PolicyGetDigest_Out;

typedef struct {
	UINT16 tag;
	UINT32 responseSize;
	UINT32 responseCode;
	UINT32 ParameterAreaSize;
	UINT16 digestSize;
	UINT8  digestData[256];	//this buffer aslo contains a UINT32 sized hash check field
} TPM_2_0_HashDigest_Out;

typedef struct {
	UINT16 tag;
	UINT32 responseSize;
	UINT32 responseCode;
	UINT32 hashSeqHandle;
} TPM_2_0_HashSequenceStart_Out;

typedef struct {
	UINT16 tag;
	UINT32 responseSize;
	UINT32 responseCode;
	UINT8  buffer[1024];
} TPM_2_0_RET_HEADER;	

typedef struct {
	UINT16 tag;
	UINT32 responseSize;
	UINT32 responseCode;
	UINT32 parameterSize;
	UINT16 nonceSize;
	UINT8  buffer[100];
} TPM_2_0_WRITE_RESPONSE;
/*
typedef struct {
	UINT16 tag;					//2
	UINT32 commandSize;			//4
	UINT32 commandCode;			//4
	//handle area
	UINT32 authHandle;			//4
	UINT32 nvIndex;				//4
	//auth area
	UINT32 authorizationSize;	//4
	UINT32 sessionHandle;		//4
	UINT16 nonceSize;			//2
	UINT8  sessionAttributes;	//1
	UINT16 passwordSize;		//4
	//params
	UINT16 size;				//2
	UINT16 offset;				//2
	
} TPM20_NVRead_Index_In;		//37
*/
typedef struct {
	UINT16 tag;
	UINT32 responseSize;
	UINT32 responseCode;
	UINT32 responseParamSize;
	UINT16 reponseDataSize;
	UINT8 *data;

} TPM20_NVRead_Index_Out;		//

typedef struct {
	UINT16 tag;
	UINT32 commandSize;
	UINT32 commandCode;
	UINT32 count;
	UINT16 hashAlg;
    UINT8  sizeofSelect;
    UINT8  pcrSelect[3];
} TPM20_ReadPcr_In;

/* Just for reference in the structure below
// Table 63 -- TPM2B_DIGEST from outputStructDef <I/O>
typedef struct {
    UINT16    size;
    BYTE      buffer[sizeof(TPMU_HA)];
} TPM2B_DIGEST;
*/
typedef struct {
	UINT16 			tag;
	UINT32 			responseSize;
	UINT32 			responseCode;
	UINT32 			pcrUpdateCounter;
	UINT32          pcrSelectionsCount;
    UINT16			hashAlg;
    UINT8           sizeofSelect;
    UINT8           pcrSelect[3];
	UINT32          digestCount;
	//this can't be indexed directly but instead the pointer has to be advanced by digests[i].size bytes each time
    TPM2B_DIGEST    digests[8];
//
} TPM20_ReadPcr_Out;

typedef struct {
  TPM_ST tag;
  UINT32 commandSize;
  TPM_CC commandCode;
  UINT16 bytesRequested;
} TPM20_GetRandom_In;

typedef struct {
  TPM_ST tag;
  UINT32 responseSize;
  UINT32 responseCode;
  UINT16 dataSize;
  UINT8 otherData[1024];

} TPM20_GetRandom_Out;

typedef struct {
  TPM_ST tag;
  UINT32 commandSize;
  TPM_CC commandCode;
  TPMI_RH_NV_INDEX nvIndex; //UINT32
} TPM20_NVReadPublic_In;

typedef struct {
  TPM_ST tag;
  UINT32 commandSize;
  TPM_CC commandCode;
  UINT32 objectHandle; //UINT32
} TPM20_ReadPublic_In;

typedef struct {
  TPM_ST tag;			//UINT16
  UINT32 responseSize;
  UINT32 responseCode;
  TPM2B_NV_PUBLIC nvPublic;
//
// NOTE: other output data consists of the following fields.  But it can't be
// specified here because some structures can vary in size.
//
//  TPM2B_NV_PUBLIC nvPublic;
//  TPM2B_NAME nvName;
//
} TPM20_NVReadPublic_Out_;

typedef struct {
  TPM_ST tag;			//UINT16
  UINT32 responseSize;
  UINT32 responseCode;
  TPM2B_PUBLIC outPublic;
//
// NOTE: other output data consists of the following fields.  But it can't be
// specified here because some structures can vary in size.
//
//  TPM2B_NAME name;
//  TPM2B_NAME qualifiedName;
//
} TPM20_ReadPublic_Out_;

typedef struct {
  TPM_ST		tag;			//UINT16
  UINT32		responseSize;
  UINT32		responseCode;
  UINT16		size;
  UINT32		nvIndex;
  UINT16		nameAlg;
  UINT32		attributes;
  UINT16		authPolicySize;
  UINT8			*authPolicy;
  UINT16		dataSize;
} TPM20_NVReadPublic_Out;

typedef struct _TPM20_Startup_In {
  TPM_ST tag;				// 2 bytes	
  UINT32 commandSize;		// 4 bytes
  TPM_CC commandCode;		// 4 bytes
  UINT16 startupType;		// 2 bytes
} TPM20_Startup_In;

typedef struct _TPM20_Startup_Out {
  UINT16 tag;
  UINT32 responseSize;
  UINT32 responseCode; 
} TPM20_Startup_Out;

typedef struct {
  TPM_ST tag;
  UINT32 commandSize;
  TPM_CC commandCode;
  TPM_SU shutdownType;
} TPM20_Shutdown_In;

typedef struct {
  TPM_ST tag;
  UINT32 responseSize;
  UINT32 responseCode;
} TPM20_Shutdown_Out;


typedef struct {
  TPM_ST tag;
  UINT32 commandSize;
  TPM_CC commandCode;
  UINT32 capability;
  UINT32 property;
  UINT32 propertyCount;
} TPM20_GetCapability_In;

typedef struct {
  UINT16 tag;
  UINT32 responseSize;
  UINT32 responseCode;
  UINT8  moreData;
  TPMS_CAPABILITY_DATA  capabilityData;
} TPM20_GetCapability_Out;

typedef struct  {
  TPM_ST tag;
  UINT32 commandSize;
  TPM_CC commandCode;
  UINT8 fullTest;
} TPM20_Selftest_In;

typedef struct {
  UINT16 tag;
  UINT32 responseSize;
  UINT32 responseCode; 
} TPM20_Selftest_Out;

//*******TPM 2 Prov Table Structures**********//

typedef struct {              //Definition for an Index                         SHA 256      SHA256       SHA256       SHA1         SHA1         SHA1
  UINT32 NvIndex;             // Index handle                                   03 00 80 01  01 00 80 01  04 00 80 01  03 00 80 01  01 00 80 01  04 00 80 01
  UINT8  bWrite;              // Indicates if BIOS writes the data              00           01           00           00           01           00
  UINT8  bWriteProtect;       // Indicates if BIOS write-protects the data      00           01           00           00           01           00
  UINT16 Reserved;            // Reserved for future use                        00 00        00 00        00 00        00 00        00 00        00 00
  UINT32 CreateCmdSize;       // size of TPM command to create the index        4D 00 00 00  4D 00 00 00  4D 00 00 00  41 00 00 00  41 00 00 00  41 00 00 00
  UINT16 CreateCmdOffset;     // Offset from table start to TPM create command  FF FF        FF FF        FF FF        FF FF        FF FF        FF FF
  UINT32 WriteCmdSize;        // size of TPM command to write the index         00 00 00 00  69 00 00 00  00 00 00 00  00 00 00 00  69 00 00 00  00 00 00 00
  UINT16 WriteCmdOffset;      // Offset from table start to TPM wrie command    FF FF        FF FF        FF FF        FF FF        FF FF        FF FF
} NV_INFO;                    //20 bytes

typedef struct {              // TPM2 ProvParameters (one per Hash Alg)            sha1           sha256
  UINT16 HashAlgID;           // Hash algorithm                                    04 00          0B 00  
  UINT16 HashDigestSize;      // Size of hash digest                               14 00          20 00
  UINT32 SetPhPolSize;        // Size of SetPhPol command                          33 00 00 00    3F 00 00 00
  UINT16 SetPhPolOffset;      // Offset from table start to PH authPolicy command  FF FF          FF FF
  UINT16 Reserved;            // Reserved for future use                           00 00          00 00
  UINT8  NumIndexes;          // Number of indexes to create                       03             03
  UINT8  NvInfoSize;          // Size of NV_INFO for a sanity check                14             14
  UINT16 ParamsOffset;        // Offset of array of NV_INFO Indexes for this algorithm                   
} ALG_INFO;                   // 16 bytes
  
typedef struct {              // TPM2 Binary Provisioning table
  UINT64    Signature;          // "TPM2Prov"
  UINT32    Length;             // Total length if this binary table
  UINT8     Major;            // Major Version                                  01
  UINT8     Minor;            // Minor Version                                  00
  UINT16    Reserved[3];      // Reserved for future use                        00 00 00 00 00 00 
  UINT8     UserInfo[32];     // Reserved not used by prov driver               00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  UINT16    Reserved1;        // Reserved for future use                        00 00
  UINT8     NumAlgs;          // Number of algorithms to test                   02
  UINT8     AlgInfoSize;      // Size of ALG_INFO sanity check 16 bytes         10
  ALG_INFO  AlgParams[4];     // array of information for each algorithm
} PROV2_TABLE;   

typedef struct {              // TPM1.2 Provisioning Table 
	UINT64  Signature;          // "TPM1Prov"
	UINT32  Length;             // Total length if this binary table
	UINT8   Major;              // Major Version                                  01
	UINT8   Minor;              // Minor Version                                  00
	UINT16  Reserved[3];        // Reserved for future use                        00 00 00 00 00 00
	UINT8   UserInfo[32];       // Reserved - not used by prov driver             31 31 2D 32 35 2D 32 30 31 34 20 54 50 4D 31 2E 32 20 50 72 6F 76 20 47 65 6E 20 54 6F 6F 6C 00
	UINT16  Reserved1;          // Reserved for future use                        00 00
	UINT8   NumIndexes;         // Number of NV Indexes to provision              04
	UINT8   NvInfoSize;         // Size of NV_INFO for a sanity check 20 bytes    14
	NV_INFO Params[8];          // Indexes to be provisioned 20 x 4 bytes
} PROV1_TABLE;                // 148 bytes with 4 indexes

#pragma pack (pop)

/***************TPM Tool Menu Functions****************************/

//BOOLEAN init20AuxDefineSpace(TPM_2_0_AUXDEF *defSpace);
//BOOLEAN init20AuxData(TPM_2_0_NV_AUX_Data *auxPolicy);
//BOOLEAN init20PSDefineSpace(TPM_2_0_PSDEF *defSpace);
//BOOLEAN init20PSPolicy(TPM_2_0_NV_PS_Policy *psPolicy);
//BOOLEAN init20PODefineSpace(TPM_2_0_PODEF *defSpace);
//BOOLEAN init20DefStructure( /*DEF_STRUCT *defStruct*/ );

/***************File Read Functions**********************************************/
BOOLEAN readFileHeader(FILE *file, FILE_HEADER *fileHeader);
BOOLEAN read_FILEHEADER(EFI_FILE_HANDLE	*FileHandle, FILE_HEADER *fileHeader);
BOOLEAN read_T2T_ARCHLIMITS(EFI_FILE_HANDLE	*FileHandle, T2T_ARCHLIMITS *archLimits);
BOOLEAN read_T2T_SESSION_DEF_FILE(EFI_FILE_HANDLE *FileHandle, T2T_SESSION_DEF_FILE *sDef);
BOOLEAN read_FSR2B_KEY(EFI_FILE_HANDLE *FileHandle, FSR2B_KEY *fsr2bKey);
BOOLEAN read_FSR2B_AUTH(EFI_FILE_HANDLE *FileHandle, FSR2B_AUTH *fsr2bAuth);
BOOLEAN read_TPMT_SYM_DEF(EFI_FILE_HANDLE *FileHandle, TPMT_SYM_DEF *symDef);

BOOLEAN read_T2T_NV_DEF_FILE(EFI_FILE_HANDLE *FileHandle, T2T_NV_DEF_FILE *iDef);
BOOLEAN read_FSR2B_DIGEST(EFI_FILE_HANDLE *FileHandle, FSR2B_DIGEST *fsr2bDigest);
BOOLEAN read_FSR2B_DATABUF(EFI_FILE_HANDLE *FileHandle, FSR2B_DATABUF *fsr2bDataBuffer);
BOOLEAN read_FSR2B_NV_PUBLIC(EFI_FILE_HANDLE *FileHandle, FSR2B_NV_PUBLIC *fsr2bNvPublic);

BOOLEAN read_T2P_AUTH(EFI_FILE_HANDLE *FileHandle, T2P_AUTH *pTp2Auth);
BOOLEAN read_T2P_DATA(EFI_FILE_HANDLE *FileHandle, T2P_DATA *pTp2Data);
BOOLEAN read_T2P_CONFIG_FILE(EFI_FILE_HANDLE *FileHandle, T2P_CONFIG_FILE *sCfg);
BOOLEAN read_T2P_SESSION_CONTEX(EFI_FILE_HANDLE *FileHandle, T2P_SESSION_CONTEX *sessionContext);
BOOLEAN read_T2P_SEQUENCE_CONTEXT(EFI_FILE_HANDLE *FileHandle, T2P_SEQUENCE_CONTEXT *pSequContext);

BOOLEAN read_T2T_POLA_SIGNED(EFI_FILE_HANDLE *FileHandle, T2T_POLA_SIGNED *paramsSign);
BOOLEAN read_T2T_POLA_SECRET(EFI_FILE_HANDLE *FileHandle, T2T_POLA_SECRET *paramsSecret);
BOOLEAN read_T2T_POLA_TICKET(EFI_FILE_HANDLE *FileHandle, T2T_POLA_TICKET *paramsTicket);
BOOLEAN read_T2T_POLA_OR(EFI_FILE_HANDLE *FileHandle, T2T_POLA_OR *paramsOR);
BOOLEAN read_FSES_PCR_SELECTION(EFI_FILE_HANDLE *FileHandle, FSES_PCR_SELECTION *pcrs);
BOOLEAN read_T2T_POLA_PCR(EFI_FILE_HANDLE *FileHandle, T2T_POLA_PCR *paramsPCR);
BOOLEAN read_T2T_POLA_NV(EFI_FILE_HANDLE *FileHandle, T2T_POLA_NV *paramsNV);
BOOLEAN read_T2T_POLA_CNTRTIMER(EFI_FILE_HANDLE *FileHandle, T2T_POLA_CNTRTIMER *paramsCT);
BOOLEAN read_T2T_POLA_AUTHORIZE(EFI_FILE_HANDLE *FileHandle, T2T_POLA_AUTHORIZE *paramsAuth);
BOOLEAN read_T2T_POLICY_DEF_FILE(EFI_FILE_HANDLE *FileHandle, T2T_POLICY_DEF_FILE *pDef);
BOOLEAN read_T2T_POL_SET_FILE( EFI_FILE_HANDLE *FileHandle, T2T_POL_SET_FILE *polSetFile );

BOOLEAN read_TPMU_PUBLIC_PARMS( EFI_FILE_HANDLE *FileHandle, TPMU_PUBLIC_PARMS *publicParams );
BOOLEAN read_T2T_K_DEF_FILE(EFI_FILE_HANDLE *FileHandle, T2T_K_DEF_FILE *kDef);
BOOLEAN read_T2T_CDEF_FILE(EFI_FILE_HANDLE *FileHandle, T2T_CDEF_FILE *cDef);
BOOLEAN read_T2P_SOBJ(EFI_FILE_HANDLE *FileHandle, T2T_SOBJ_FILE *sObj);
BOOLEAN read_T2T_DUP_FILE(EFI_FILE_HANDLE *FileHandle, T2T_DUP_FILE *dDef);
/*******************************************************************************/

UINT8 initFileHeader( FILE_HEADER *fileHeader);

/***************File Write Functions**********************************************/

BOOLEAN update_FILE_HEADER(EFI_FILE_HANDLE *FileHandle, FILE_HEADER *header);
BOOLEAN update_FSR2B_KEY(EFI_FILE_HANDLE *FileHandle, FSR2B_KEY *fsr2bKey);
BOOLEAN update_FSR2B_AUTH(EFI_FILE_HANDLE *FileHandle, FSR2B_AUTH *fsr2bAuth);
BOOLEAN update_T2P_SEQUENCE_CONTEXT(EFI_FILE_HANDLE *FileHandle, T2P_SEQUENCE_CONTEXT *squeContext);
BOOLEAN update_T2P_CONFIG_FILE(EFI_FILE_HANDLE *FileHandle, T2P_CONFIG_FILE *sCfg);
BOOLEAN update_T2T_DATA_FILE( EFI_FILE_HANDLE *FileHandle, T2T_DATA_FILE *dataFile );
BOOLEAN update_T2T_DIGEST_LIST_FILE( EFI_FILE_HANDLE *FileHandle, T2T_DIGEST_LIST_FILE *digestListFile );
BOOLEAN update_T2P_SOBJ_FILE(EFI_FILE_HANDLE *FileHandle, T2T_SOBJ_FILE *sObj);
/*******************************************************************************/

/**************Packing Functions************************************************/
UINT8 PackNonce(T2P_CMDAREA *pArea, T2T_SESSION_DEF_FILE *psDef);
UINT8 Pack2B( T2P_AUTHAREA *pArea, T2P_AUTH *authValue );
UINT8 PackVDR(T2P_CMDAREA *pArea, VDR_DATABUF *pVDR, UINT16 size, T2P_CONFIG_FILE *sCfg);
UINT8 PackT2T_DATA(T2P_CMDAREA *pArea, T2T_DATA *pDATA, T2P_CONFIG_FILE *sCfg);
UINT8 PackFSR2B_DATABUF(T2P_CMDAREA *pArea, FSR2B_DATABUF *dataSource, T2P_CONFIG_FILE *sCfg);
UINT8 PackSymDef(T2P_CMDAREA *pArea, TPMT_SYM_DEF *pSymDef);
UINT8 PackAuthSession(T2P_AUTHAREA	*pArea, T2P_CONFIG_FILE *sCfg, UINT8 sessionNumber);
UINT8 PackFSR2B_NV_PUBLIC(T2P_CMDAREA *pArea, FSR2B_NV_PUBLIC *publicInfo, T2P_CONFIG_FILE *sCfg);
UINT8 PackNvPublic(T2P_CMDAREA *pArea, FSRS_NV_PUBLIC *publicInfo, T2P_CONFIG_FILE *sCfg);
/******************************************************************************/

void displayTPM2info();
void DisplayTPMStatus();

/********************************************************************/
BOOLEAN verify20TPMPresence();
BOOLEAN setActiveLocality0();
BOOLEAN nextStateTransition();


/****************************TPM Commands****************************************/
UINT8 TPM_20_SendGenericCommand( T2P_CMD_SGL *pPackedCmd );
UINT8 TPM_20_ExecuteCommand( T2P_CMD_SGL *pPackedCmd, UINT8* responseBuffer, UINT32 *responseSize, UINT16 *tag );
UINT8 TPM_20_Startup( UINT16 startupType );
UINT8 TPM_20_Shutdown( UINT16 startupType );
UINT8 TPM_20_SelfTest( BOOLEAN selfTestMode );
UINT8 TPM_20_NV_ReadValue_cmd();
UINT8 TPM_20_Read_NV_Index_List();
UINT8 TPM_20_NV_ReadPublic(UINT32 index, UINT32 dataSize, FSR2B_NV_PUBLIC *nvPublic, TPM2B_NAME *name, BOOLEAN verbose);
UINT8 TPM_20_ReadPublic(UINT32 objectHandle, TPM2B_PUBLIC *publicInfo, TPM2B_NAME *name, TPM2B_NAME *qualifiedName, BOOLEAN verbose);
UINT8 TPM_20_NV_Read( T2P_CMD_SGL *pPackedCmd, UINT8 *indexData, UINT32 dataSize, BOOLEAN verbose);
UINT8 TPM_20_HashSequenceStart( T2P_CMD_SGL *pPackedCmd, UINT32 *hashSeqHandle );
UINT8 TPM_20_HashSequenceComplete( T2P_CMD_SGL *pPackedCmd, UINT8 *dataHash, UINT16 *digestSize );
UINT8 TPM_20_GetRandom( UINT8 *data, UINT16 *digestSize );
UINT8 TPM_20_CreatePrimary( T2P_CMD_SGL *pPackedCmd, UINT32 *keyHandle, UINT8 *outPublic, UINT16 *size );
UINT8 TPM_20_LoadExternal( T2P_CMD_SGL *pPackedCmd, UINT32 *objectHandle, UINT8 *objectName, UINT16 *nameSize);
UINT8 TPM_20_Create( T2P_CMD_SGL *pPackedCmd, UINT8 *outPublic, UINT16 *sizePublic, UINT8 *outPrivate, UINT16 *sizePrivate);
UINT8 TPM_20_ReadPCR( UINT16 tpmAlgId, UINT8 PCRSelect0, UINT8 PCRSelect1, UINT8 PCRSelect2 );
UINT8 TPM_20_Get_Capability(UINT32 capability, UINT32 property, UINT32 propertyCount, BOOLEAN verbose);
//UINT8 TPM_20_StartAuthSession( UINT32 *authSessionHandle );
UINT8 TPM_20_StartAuthSession(T2P_CMD_SGL *pPackedCmd, UINT32 *authSessionHandle, UINT16 *nonceSize, UINT8 *nonce);
UINT8 TPM_20_PolicyLocality(T2P_CMD_SGL *pPackedCmd);
UINT8 TPM_20_PolicyGetDigest( T2P_CMD_SGL *pPackedCmd, UINT8 *authPolicyHash, UINT16 *digestSize );
UINT8 TPM_20_FlushContext( UINT32 IN authSessionHandle );
UINT8 TPM_20_NV_Delete_Index( T2P_CMD_SGL *pPackedCmd );
UINT8 TPM_20_NV_Write( T2P_CMD_SGL *pPackedCmd );
UINT8 TPM_20_NV_Verify_Def(FSR2B_NV_PUBLIC *nvPublic0, FSR2B_NV_PUBLIC *nvPublic1, UINT32 verify, FSR2B_AUTH *auth );

BOOLEAN packNvReadVerifyDef(T2P_CMD_SGL *packedCmd, T2P_CMD_HEADER *cmdHeader, T2P_HANDLE_AREA *cmdHandles, T2P_AUTHAREA *cmdAuthArea, T2P_CP_BUF *cmdParamArea, 
						FSR2B_NV_PUBLIC *nvPublic0, FSR2B_AUTH *auth, UINT32 attributeMask);


/*****************Helper Functions*****************/
UINT16 ChangeEndiannessWordASM();
UINT32 ChangeEndiannessDWordASM();
//BOOLEAN ChangeEndiannessTPMDefineSpace(TPM_2_0_AUXDEF *tpmDefineSpace);
//BOOLEAN ChangeEndiannessTPMPSPolicy(TPM_2_0_NV_PS_Policy *psPolicy);
//BOOLEAN ChangeEndiannessTPMAuxData(TPM_2_0_NV_AUX_Data *psPolicy);

/****************TPM Status Check functions********************/
UINT8 tpmRegValidStsStatusCheck(void *pBuffer);


/********************************************************************/

CHAR16 *mystrtok(CHAR16* string, const CHAR16 *delim);
/**
  CaseInsensitive length limited string comparison.

  @param[in] Source   Pointer to first string.
  @param[in] Target   Pointer to second string.
  @param[in] Count    Number of characters to compare.

  @retval 0   The strings are the same.
  @return     non-zero if the strings are different.
**/
CONST CHAR16*
EFIAPI
StrniCmp(
  IN CONST CHAR16 *Source,
  IN CONST CHAR16 *Target,
  IN CONST UINTN  Count
  );

#endif //_TPM_20_INFO